/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.vectrex.ui;

import frc.emul.vectrex.ui.GfxItem;
import frc.emul.vectrex.ui.config.UIUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreviewCanvas
extends JComponent {
    public static boolean DEBUG_ZOOM = false;
    public static boolean DEBUG_BACKGROUND = false;
    public static boolean SHOW_REFERENCE_GRID = false;
    public static boolean SHOW_REFERENCE_GRID_ZOOM = false;
    public static boolean SHOW_REFERENCE_DEBUG_ZOOM = false;
    public static boolean SEE_THROUGH_ZOOM = DEBUG_BACKGROUND;
    public static boolean USE_DOT_CURSOR = SHOW_REFERENCE_GRID_ZOOM;
    public static boolean ADJUST_ZOOM = true;
    private static final int BORDER = 1;
    private static final float MIN_ZOOM_FACTOR = 1.0f;
    private static final float DEFAULT_ZOOM_FACTOR = 2.0f;
    private static final float ZOOM_FACTOR_RESET = 2.0f;
    private static final float ZOOM_FACTOR_STEP = 1.1f;
    private static final float ZOOM_FACTOR_WHEEL = 0.25f;
    private static final float ZOOM_RADIUS_DIVISOR = 3.1f;
    private static final Stroke STROKE_ZOOM_OUTLINE = new BasicStroke(2.0f);
    private static final Stroke STROKE_POINT_X1 = new BasicStroke(1.5f);
    private static final Stroke STROKE_LINE_X1 = new BasicStroke(0.85f);
    private static final Stroke STROKE_POINT_ZOOM = new BasicStroke(2.25f);
    private static final Stroke STROKE_LINE_ZOOM = new BasicStroke(1.0f);
    private static final Color COLOR_BGND_INVALID = new Color(72, 0, 0);
    private static final Color COLOR_BGND_VALID = Color.BLACK;
    private static final Color COLOR_ZOOM_OUTLINE = UIManager.getColor("List.selectionBackground");
    private static final Color COLOR_ZOOM_CLEAR = DEBUG_BACKGROUND ? new Color(0, 0, 0, 160) : new Color(0, 0, 0, 216);
    private volatile List<GfxItem> gfx;
    private volatile boolean matching;
    private volatile Point zoomAt;
    private volatile float zoomFactor;
    private final Color[] brightness;
    private final Strokes STROKES_NORMAL = new Strokes(STROKE_POINT_X1, STROKE_LINE_X1);
    private final Strokes STROKES_ZOOM = new Strokes(STROKE_POINT_ZOOM, STROKE_LINE_ZOOM);

    public PreviewCanvas() {
        this.setOpaque(false);
        this.setBorder(BorderFactory.createBevelBorder(1));
        this.zoomFactor = 2.0f;
        this.brightness = new Color[256];
        int n = 0;
        while (n < this.brightness.length) {
            int n2 = Math.min(255, 2 * n);
            this.brightness[n] = 255 == n2 ? Color.WHITE : new Color(n2, n2, n2);
            ++n;
        }
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                PreviewCanvas.this.updateZoom(mouseEvent);
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                PreviewCanvas.this.updateZoom(mouseEvent);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                PreviewCanvas.this.updateZoom(mouseEvent);
            }

            public void mouseExited(MouseEvent mouseEvent) {
                PreviewCanvas.this.updateZoom(null);
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isMiddleMouseButton(mouseEvent)) {
                    PreviewCanvas.this.setZoom(mouseEvent, 2.0f);
                } else if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    PreviewCanvas.this.setZoom(mouseEvent, PreviewCanvas.this.zoomFactor * 1.1f);
                } else if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    PreviewCanvas.this.setZoom(mouseEvent, PreviewCanvas.this.zoomFactor / 1.1f);
                }
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                PreviewCanvas.this.setZoom(mouseWheelEvent, PreviewCanvas.this.zoomFactor - 0.275f * (float)mouseWheelEvent.getWheelRotation());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGraphicItems(List<GfxItem> list, boolean bl) {
        boolean bl2;
        if (list != null) {
            bl2 = true;
            GfxItem.sortByBrightness(list);
        } else {
            bl2 = this.gfx != null;
        }
        Color[] colorArray = this.brightness;
        synchronized (this.brightness) {
            this.matching = bl;
            this.gfx = list;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (bl2) {
                this.repaint();
                this.updateCursor(this.gfx == null);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics graphics) {
        Point point = this.zoomAt;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Color[] colorArray = this.brightness;
        synchronized (this.brightness) {
            List<GfxItem> list = this.gfx;
            boolean bl = this.matching;
            // ** MonitorExit[var6_4] (shouldn't be in output)
            boolean bl2 = list != null;
            int n = this.getHeight();
            int n2 = this.getWidth();
            graphics2D.setColor(this.getBackground());
            graphics2D.fillRect(0, 0, n2, n);
            Insets insets = this.getInsets();
            n2 = n2 - insets.left - insets.right;
            n = n - insets.top - insets.bottom;
            if (bl2) {
                Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                Stroke stroke = graphics2D.getStroke();
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setColor(bl ? COLOR_BGND_VALID : COLOR_BGND_INVALID);
                graphics2D.fillRect(insets.left, insets.top, n2, n);
                this.paintItems(graphics2D, list, 1.0f, this.STROKES_NORMAL, 0, 0, insets.left + 1, insets.top + 1, n2 - 2, n - 2);
                if (point != null) {
                    int n3 = point.x;
                    int n4 = point.y;
                    int n5 = (int)((float)n2 / 3.1f);
                    Shape shape = graphics2D.getClip();
                    graphics2D.setColor(SEE_THROUGH_ZOOM ? COLOR_ZOOM_CLEAR : Color.BLACK);
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                    graphics2D.fillOval(n3 - n5, n4 - n5, 1 + 2 * n5, 1 + 2 * n5);
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    graphics2D.setClip(new Ellipse2D.Float((float)(n3 - n5) + 0.5f, (float)(n4 - n5) + 0.5f, 2 * n5 + 1, 2 * n5 + 1));
                    this.paintItems(graphics2D, list, this.zoomFactor, this.STROKES_ZOOM, n3, n4, insets.left + 1, insets.top + 1, n2 - 2, n - 2);
                    graphics2D.setClip(shape);
                    graphics2D.setColor(COLOR_ZOOM_OUTLINE);
                    graphics2D.setStroke(STROKE_ZOOM_OUTLINE);
                    graphics2D.drawOval(n3 - n5, n4 - n5, 1 + 2 * n5, 1 + 2 * n5);
                    if (SHOW_REFERENCE_GRID_ZOOM) {
                        graphics2D.setStroke(new BasicStroke(0.5f));
                        graphics2D.drawLine(n3 - n5, n4, n3 + n5, n4);
                        graphics2D.drawLine(n3, n4 - n5, n3, n4 + n5);
                    }
                }
                graphics2D.setStroke(stroke);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
                if (DEBUG_ZOOM) {
                    graphics2D.setColor(new Color(255, 255, 0, 75));
                    graphics2D.drawString("x " + this.zoomFactor, insets.left + 2, n - 1);
                    graphics2D.drawString("x " + this.zoomFactor, insets.left + 3, n - 2);
                    graphics2D.setColor(new Color(255, 255, 0, 200));
                    graphics2D.drawString("x " + this.zoomFactor, insets.left + 2, n - 2);
                }
            } else {
                graphics2D.setColor(Color.GRAY);
                this.drawCenteredString(graphics2D, "no preview", n2, insets.left, insets.top + n / 2 - 7);
                this.drawCenteredString(graphics2D, "available", n2, insets.left, insets.top + n / 2 + 17);
            }
            return;
        }
    }

    private void updateCursor(boolean bl) {
        this.setCursor(bl ? null : (USE_DOT_CURSOR ? UIUtils.getDotCursor() : Cursor.getPredefinedCursor(1)));
    }

    private Color getBrightnessColor(int n) {
        return n < this.brightness.length ? this.brightness[n] : Color.WHITE;
    }

    private void setZoom(MouseEvent mouseEvent, float f) {
        if ((f = Math.max(1.0f, f)) != this.zoomFactor) {
            if (ADJUST_ZOOM) {
                this.zoomFactor = f;
            }
            this.updateZoom(mouseEvent);
        }
    }

    private void updateZoom(MouseEvent mouseEvent) {
        Point point;
        Point point2 = point = mouseEvent == null ? null : mouseEvent.getPoint();
        if (point != this.zoomAt) {
            this.zoomAt = point;
            this.repaint();
        }
    }

    private void drawCenteredString(Graphics graphics, String string, int n, int n2, int n3) {
        Rectangle2D rectangle2D = graphics.getFontMetrics().getStringBounds(string, graphics);
        graphics.drawString(string, n2 + (int)((double)n - rectangle2D.getWidth()) / 2, n3);
    }

    private void paintItems(Graphics2D graphics2D, List<GfxItem> list, float f, Strokes strokes, int n, int n2, int n3, int n4, int n5, int n6) {
        boolean bl = f > 1.0f;
        float f2 = (float)n3 + (float)(n5 - 1) / 2.0f;
        float f3 = (float)n4 + (float)(n6 - 1) / 2.0f;
        graphics2D.translate(f2, f3);
        if (SHOW_REFERENCE_DEBUG_ZOOM) {
            graphics2D.setStroke(STROKE_LINE_ZOOM);
            graphics2D.setColor(Color.YELLOW);
            graphics2D.drawLine(0, 0, 0, -50);
            graphics2D.drawLine(0, 0, -50, 0);
        }
        float f4 = (float)n - f2;
        float f5 = (float)n2 - f3;
        float f6 = -f4 * f;
        float f7 = -f5 * f;
        if (bl) {
            graphics2D.translate(f4, f5);
            if (SHOW_REFERENCE_DEBUG_ZOOM) {
                graphics2D.setColor(Color.CYAN);
                graphics2D.drawLine(0, 0, 0, 50);
                graphics2D.drawLine(0, 0, 50, 0);
            }
            graphics2D.translate(f6, f7);
            if (SHOW_REFERENCE_DEBUG_ZOOM) {
                graphics2D.setStroke(STROKE_LINE_X1);
                graphics2D.setColor(Color.GREEN);
                graphics2D.drawLine(-35, -35, 35, 35);
                graphics2D.drawLine(-35, 35, 35, -35);
            }
        }
        Stroke stroke = strokes.points;
        Stroke stroke2 = strokes.lines;
        float f8 = f * (float)n5 / 2.0f;
        float f9 = f * (float)n6 / -2.0f;
        for (GfxItem gfxItem : list) {
            graphics2D.setColor(this.getBrightnessColor(gfxItem.brightness));
            if (gfxItem.isPoint()) {
                graphics2D.setStroke(stroke);
                graphics2D.drawLine((int)(gfxItem.x0 * f8), (int)(gfxItem.y0 * f9), (int)(gfxItem.x0 * f8), (int)(gfxItem.y0 * f9));
                continue;
            }
            graphics2D.setStroke(stroke2);
            graphics2D.drawLine((int)(gfxItem.x0 * f8), (int)(gfxItem.y0 * f9), (int)(gfxItem.x1 * f8), (int)(gfxItem.y1 * f9));
        }
        if (bl) {
            graphics2D.translate(-f6 - f4 - f2, -f7 - f5 - f3);
        } else {
            graphics2D.translate(-f2, -f3);
        }
    }

    static class Strokes {
        Stroke points;
        Stroke lines;

        Strokes(Stroke stroke, Stroke stroke2) {
            this.points = stroke;
            this.lines = stroke2;
        }
    }
}

